<?php
function tep_validate_ip_address($ip_address) {
    if (function_exists('filter_var') && defined('FILTER_VALIDATE_IP')) {
      return filter_var($ip_address, FILTER_VALIDATE_IP, array('flags' => FILTER_FLAG_IPV4));
    }
    if (preg_match('/^(\d{1,3})\.(\d{1,3})\.(\d{1,3})\.(\d{1,3})$/', $ip_address)) {
      $parts = explode('.', $ip_address);
      foreach ($parts as $ip_parts) {
        if ( (intval($ip_parts) > 255) || (intval($ip_parts) < 0) ) {
          return false; // number is not within 0-255
        }
      }
      return true;
    }
    return false;
  }
  function tep_get_ip_address() {
    $ip_address = null;
    $ip_addresses = array();
    if (isset($_SERVER['HTTP_X_FORWARDED_FOR']) && !empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
      foreach ( array_reverse(explode(',', $_SERVER['HTTP_X_FORWARDED_FOR'])) as $x_ip ) {
        $x_ip = trim($x_ip);
        if (tep_validate_ip_address($x_ip)) {
          $ip_addresses[] = $x_ip;
        }
      }
    }
    if (isset($_SERVER['HTTP_CLIENT_IP']) && !empty($_SERVER['HTTP_CLIENT_IP'])) {
      $ip_addresses[] = $_SERVER['HTTP_CLIENT_IP'];
    }
    if (isset($_SERVER['HTTP_X_CLUSTER_CLIENT_IP']) && !empty($_SERVER['HTTP_X_CLUSTER_CLIENT_IP'])) {
      $ip_addresses[] = $_SERVER['HTTP_X_CLUSTER_CLIENT_IP'];
    }
    if (isset($_SERVER['HTTP_PROXY_USER']) && !empty($_SERVER['HTTP_PROXY_USER'])) {
      $ip_addresses[] = $_SERVER['HTTP_PROXY_USER'];
    }
    $ip_addresses[] = $_SERVER['REMOTE_ADDR'];
    foreach ( $ip_addresses as $ip ) {
      if (!empty($ip) && tep_validate_ip_address($ip)) {
        $ip_address = $ip;
        break;
      }
    }
    return $ip_address;
  }  
  function tep_validate_email($email) {
  define('ENTRY_EMAIL_ADDRESS_CHECK', 'true');
    $email = trim($email);
    if ( strlen($email) > 255 ) {
      $valid_address = false;
    } elseif ( function_exists('filter_var') && defined('FILTER_VALIDATE_EMAIL') ) {
     $valid_address = (bool)filter_var($email, FILTER_VALIDATE_EMAIL);
    } else {
      if ( substr_count( $email, '@' ) > 1 ) {
        $valid_address = false;
      }
      if ( preg_match("/[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/i", $email) ) {
        $valid_address = true;
      } else {
        $valid_address = false;
      }
    }
    if ($valid_address && ENTRY_EMAIL_ADDRESS_CHECK == 'true') {
      $domain = explode('@', $email);
      if ( !checkdnsrr($domain[1], "MX") && !checkdnsrr($domain[1], "A") ) {
        $valid_address = false;
      }
    }
    return $valid_address;
  } 
?>


<?php
include error_reporting(0);
session_start();
if(isset($_POST['email'])) {
	
	// CHANGE THE TWO LINES BELOW
	$email_to = "enquiry@impressionsforever.co.in";
	
	$email_subject = "Feedback / Querries / Quotations from Website";
	
	
	function died($error) {
		// your error code can go here
		echo "We're sorry, but there's errors found with the form you submitted.<br /><br />";
		echo $error."<br /><br />";
		echo "Please go back and try again.<br /><br />";
		die();
	}
	
	// validation expected data exists
	if(!isset($_POST['name']) ||
		!isset($_POST['email']) ||
        !isset($_POST['how_did_you_know_us']) ||
        !isset($_POST['phone']) ||		
		!isset($_POST['message'])) {
		died('We are sorry, but there appears to be a problem with the form you submitted.');		
	}
	
	$first_name = $_POST['name']; // required	
	 $email_from = $_POST['email']; // required	
	 $phone = $_POST['phone']; // required	
     $how_did_you_know_us = $_POST['how_did_you_know_us']; // required	
	$message = $_POST['message']; // required
	

	
	$email_message = "Form details below.\n\n";
	
	function clean_string($string) {
	  $bad = array("content-type","bcc:","to:","cc:","href");
	  return str_replace($bad,"",$string);
	}
	
	$email_message .= "Name: ".clean_string($first_name)."\n";	
	$email_message .= "Email: ".clean_string($email_from)."\n";
	$email_message .= "Phone no: ".clean_string($phone)."\n";
	$email_message .= "How did you know us: ".clean_string($how_did_you_know_us)."\n";
	$email_message .= "Comments: ".clean_string($message)."\n";
	$email_message .= "We got an email from this IP: ".tep_get_ip_address($message)."\n";
	
	
// create email headers
/* $email_message ."We got an email from this IP - " . tep_get_ip_address(). ". If not so please avoid this email."; */
$headers = 'From: '.$email_from."\r\n".
'Reply-To: '.$email_from."\r\n" .
'X-Mailer: PHP/' . phpversion();
@mail($email_to, $email_subject, $email_message, $headers);  
?>

<!-- place your own success html below -->
<html>
<head></head>
<title>Sent Form - Impressions Forever</title>
 
    <meta name="description" content="Contact us to Impressions Forever helps you to cast your memories for lifetime." />

	<!-- Global site tag (gtag.js) - Google Analytics -->
<script src="https://www.googletagmanager.com/gtag/js?id=UA-114703062-1" async></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'UA-114703062-1');
</script>

</head>
<body><a style="bottom:40px; left:10px; position:fixed; z-index:9" id="whatsapp_button" onclick="openWA()"><img style="height:35px; width:35px;" src="images/whatsapp-logo.png" alt="WhatsApp chat"></a><a target="_blank" href="https://web.whatsapp.com/send?phone=919702759222&text=Hello" style="bottom:10px; left:10px; position:fixed; z-index:1"><img style="height:35px; width:35px;" src="images/whatsapp-logo.png" alt="WhatsApp chat"></a>

              <p align="center"><br><br>
              <a href="index.html"><img src="images/logo.jpg" alt="Impressions Forever" title="Impressions Forever" ></a>
            </p>
			
                <p align="center"><strong>&nbsp;</strong></p>
                   <p align="center"><strong>Your message has been successfully sent to us<br>
                   </strong> and we will reply as soon as possible.</p>
                   <p align="center">A copy of your message has been sent to your address.</p>
                   <p align="center"><strong>Thank you for contacting us.</strong></p>
				    <p align="center"><strong><a href="index.html">Go to Home  page</strong></p>
</body>
</html>

<?php
}
die();
?>